/*================================================================================
*             
* (c) Crestron Electronics, Incorporated. All Rights Reserved.
*
* Use of this software is controlled by the terms and conditions found
* in the license agreement under which this software has been supplied.
*
================================================================================*/
//
//  File:  eep_params.h
//
//  This file contains the structures and variables needed to be stored in the
//  EEPROM (section in the flash). Parameters such as MAC address, IP address
//  etc can be put in this section.
////////////////////////////////////////////////////////////////////////////////
#ifndef __EEP_PARAMS_H_
#define __EEP_PARAMS_H_

#include "hprfgw_config.h"

///////////////////////////////////////////////////////////////////////////
//////////      READ ME     ///////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
// Currently the User EEP data is stored in the BOOT_CFG structure. The max
// size for the BOOT_CFG is one sector, that is 2048 bytes. Make sure we
// consider BOOT_CFG structure when adding more stuff.

// In order to update or read the EEPOM block, user needs to create their
// own local variable of type EEP_PARAMS then use that in the IOCTL. To
// update a variable in this section, user first need to read the content
// to their local copy and then update the parameter to be set and pass
// the local copy to write IOCTL (read modify write)
//////////////////////////////////////////////////////////////////////////
// Structure.
// IMPORTANT: Strcture has additional (unused) bytes for adding new items
// without actually changing the actual structure size. Note that this
// strcture is also used in Updater. So if the structure size changes,
// we may need an updater build as well.
////////////////////////
//#pragma pack(1)
typedef struct
{
    UINT32  dwSignature;    // Signature
    UINT32  dwVersion;      // Version no.
    
    // <<-- Start of actual parameters
    UINT32  RfUIDSign;      // UID signature
    UINT8   RfUID[8];       // RF UID (for HPRF radio)

    // <<-- Add new stuff here. Increase the version number if needed.
	UINT16	RfPowerTable;	// Table number defining power level limits.
    // As far as possible, 4 byte multiples, and reduce same bytes in the "unused" below.

    UINT8   Unused[98];    // Unused (for future use without increasing structure size)

} EEP_PARAMS;
//#pragma pack()
////////////////////////
// Version and signature
#define EEP_SIGNATURE			0xDEADBABE
#define EEP_VERSION				2

// Note on signature and versions.
// For now, the signature and the version is updated by the HPRF module.
// It can be done in a generic module later on if needed.
// For now, this structure is used only inside HPRF driver.


///////////////////////////////////////////////////////////////////////////////
/////////// IOCTLS
//////////////
#define IOCTL_WRITE_USER_EEP         \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 3150, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_READ_USER_EEP         \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 3151, METHOD_BUFFERED, FILE_ANY_ACCESS)

//------------------------------------------------------------------------------

///////////////////////////////////////////////////////////////////////////////
/////////// Return value structure for VerifyUserEepParams().  [ NOT USED ]
typedef struct
{
	UINT32 dwOldSign;        // Old signature what was there
	UINT32 dwOldVer;         // Old version what was there
	UINT32 dwNewSign;        // New signature what is now
	UINT32 dwNewVer;         // New Version what is now
	UINT32 dwRestoreDone;    // Restore done?
}stEEP_VERIFY;


#endif  /* #ifndef __EEP_PARAMS_H_ */
